<?php

if (function_exists('register_sidebar')) {
	register_sidebar(array(
		'name' => 'Side Bar',
		'before_widget' => '<div class="box box-%2$s">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3>',
		'after_title' => '</h3><div class="interior">',
	));
}
//GsL98DGtpo0W


function themefunction_list_bookmarks() {
	$array = array();
	$array[] = 'class=box box-blogroll';
	$array[] = 'category_before=<div class="%class">';
	$array[] = 'category_after=</div></div>';
	$array[] = 'title_before=<h3>';
	$array[] = 'title_after=</h3><div class="interior">';
	$array[] = 'categorize=0';
	$array[] = 'title_li=Blogroll';
	wp_list_bookmarks(implode('&',$array)); 
}

function themefunction_recentcomments() {
	echo '<ul>';
	themefunction_format_recentcomments();
	echo '</ul>';
}

function themefunction_list_pages_flat($args = '') {
	$defaults = array(
		'depth' => 0, 'show_date' => '',
		'date_format' => get_option('date_format'),
		'child_of' => 0, 'exclude' => '',
		'title_li' => __('Pages'), 'echo' => 1,
		'authors' => '', 'sort_column' => 'menu_order, post_title'
	);

	$r = wp_parse_args( $args, $defaults );
	extract( $r, EXTR_SKIP );

	$output = '';
	$current_page = 0;

	// sanitize, mostly to keep spaces out
	$r['exclude'] = preg_replace('[^0-9,]', '', $r['exclude']);

	// Allow plugins to filter an array of excluded pages
	$r['exclude'] = implode(',', apply_filters('wp_list_pages_excludes', explode(',', $r['exclude'])));

	// Query pages.
	$r['hierarchical'] = 0;
	$pages = get_pages($r);

	if ( !empty($pages) ) {
		if ( $r['title_li'] )
			$output .= '<li class="pagenav">' . $r['title_li'] . '<li>';

		global $wp_query;
		if ( is_page() || $wp_query->is_posts_page )
			$current_page = $wp_query->get_queried_object_id();
		$output .= themefunction_walk_page_tree($pages, $r['depth'], $current_page, $r);

	}

	$output = apply_filters('themefunction_list_pages_flat', $output);

	if ( $r['echo'] )
		echo $output;
	else
		return $output;
}

function themefunction_walk_page_tree() {
	$tfwalker = new TF_Walker_Page;
	$args = func_get_args();
	return call_user_func_array(array(&$tfwalker, 'walk'), $args);
}

class TF_Walker_Page extends Walker {
	var $tree_type = 'page';
	var $db_fields = array ('parent' => 'post_parent', 'id' => 'ID'); //TODO: decouple this

	function start_lvl($output, $depth) {
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent\n";
		return $output;
	}

	function end_lvl($output, $depth) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent\n";
		return $output;
	}

	function start_el($output, $page, $depth, $current_page, $args) {
		if ( $depth )
			$indent = str_repeat("\t", $depth);
		else
			$indent = '';

		extract($args, EXTR_SKIP);
		$css_class = 'page_item page-item-'.$page->ID;
		if ( !empty($current_page) ) {
			$_current_page = get_page( $current_page );
			if ( in_array($page->ID, (array) $_current_page->ancestors) )
				$css_class .= ' current_page_ancestor';
			if ( $page->ID == $current_page )
				$css_class .= ' current_page_item';
			elseif ( $_current_page && $page->ID == $_current_page->post_parent )
				$css_class .= ' current_page_parent';
		}

		$output .= $indent . '<li class="' . $css_class . '"><a href="' . get_page_link($page->ID) . '" title="' . attribute_escape(apply_filters('the_title', $page->post_title)) . '">' . apply_filters('the_title', $page->post_title) . '</a></li>';

		if ( !empty($show_date) ) {
			if ( 'modified' == $show_date )
				$time = $page->post_modified;
			else
				$time = $page->post_date;

			$output .= " " . mysql2date($date_format, $time);
		}

		return $output;
	}

	function end_el($output, $page, $depth) {
		$output .= "\n";

		return $output;
	}

}

function themefunction_format_recentcomments(
	$no_comments = 5,
	$show_pass_post = false,
	$title_length = 35, 	// shortens the title if it is longer than this number of chars
	$author_length = 15,	// shortens the author if it is longer than this number of chars
	$wordwrap_length = 35, // adds a blank if word is longer than this number of chars
	$type = 'all', 	// Comments, trackbacks, or both?
	$format = '<li><a href="%permalink%" title="%title%"><strong>%author_name%</strong> in %title%</a>: %excerpt%</li>',
	$date_format = 'd.m.y, Hno',
	$none_found = '<li>No comments.</li>',	// None found
	$type_text_pingback = 'Pingback by',
	$type_text_trackback = 'Trackback by',
	$type_text_comment = 'By',
	$comment_length = 40

	) {

	//Language...
	$mwlang_anonymous = 'Anonymous'; // Anonymous
	$mwlang_authorurl_title_before = 'Webseite von &lsaquo;';
	$mwlang_authorurl_title_after = '&rsaquo; besuchen';

	global $wpdb;

	$request = "SELECT ID, comment_ID, comment_content, comment_author, comment_author_url, comment_date, post_title, comment_type
				FROM $wpdb->comments LEFT JOIN $wpdb->posts ON $wpdb->posts.ID=$wpdb->comments.comment_post_ID
				WHERE post_status IN ('publish','static')";

	switch($type) {
		case 'all':
			// add nothing
			break;
		case 'comment_only':
			//
			$request .= "AND $wpdb->comments.comment_type='' ";
			break;
		case 'trackback_only':
			$request .= "AND ( $wpdb->comments.comment_type='trackback' OR $wpdb->comments.comment_type='pingback' ) ";
			break;
		default:
			//
			break;
	}

	if (!$show_pass_post) { 
		$request .= "AND post_password ='' ";
	}

	$request .= "AND comment_approved = '1' ORDER BY comment_ID DESC LIMIT $no_comments";

	$comments = $wpdb->get_results($request);
	$output = '';
	if ($comments) {
		foreach ($comments as $comment) {

			// Permalink to post/comment
			$loop_res['permalink'] = get_permalink($comment->ID). '#comment-' . $comment->comment_ID;

			// Title of the post
			$loop_res['post_title'] = stripslashes($comment->post_title);
			$loop_res['post_title'] = wordwrap($loop_res['post_title'], $wordwrap_length, ' ' , 1);

			if (strlen($loop_res['post_title']) >= $title_length) {
				$loop_res['post_title'] = substr($loop_res['post_title'], 0, $title_length) . '&#8230;';
			}

			// Author's name only
			$loop_res['author_name'] = stripslashes($comment->comment_author);
			$loop_res['author_name'] = wordwrap($loop_res['author_name'], $wordwrap_length, ' ' , 1);

			if ($loop_res['author_name'] == '') $loop_res['author_name'] = $mwlang_anonymous;
			if (strlen($loop_res['author_name']) >= $author_length) {
				$loop_res['author_name'] = substr($loop_res['author_name'], 0, $author_length) . '&#8230;';
			}

			// Full author (link, name)
			$author_url = $comment->comment_author_url;
			if (empty($author_url)) {
				$loop_res['author_full'] = $loop_res['author_name'];
			} else {
				$loop_res['author_full'] = '<a href="' . $author_url . '" title="' . $mwlang_authorurl_title_before . $loop_res['author_name'] . $mwlang_authorurl_title_after . '">' . $loop_res['author_name'] . '</a>';
			}

			// Comment excerpt
			$comment_excerpt = strip_tags($comment->comment_content);
			$comment_excerpt = stripslashes($comment_excerpt);
			if (strlen($comment_excerpt) >= $comment_length) {
				$comment_excerpt = substr($comment_excerpt, 0, $comment_length) . '...';
			}

			// Comment type
			if ( $comment->comment_type == 'pingback' ) {
				$loop_res['comment_type'] = $type_text_pingback;
			} elseif ( $comment->comment_type == 'trackback' ) {
				$loop_res['comment_type'] = $type_text_trackback;
			} else {
				$loop_res['comment_type'] = $type_text_comment;
			}

			// Date of comment
			$loop_res['comment_date'] = mysql2date($date_format, $comment->comment_date);

			// Output element
			$element_loop = str_replace('%permalink%', $loop_res['permalink'], $format);
			$element_loop = str_replace('%title%', $loop_res['post_title'], $element_loop);
			$element_loop = str_replace('%author_name%', $loop_res['author_name'], $element_loop);
			$element_loop = str_replace('%author_full%', $loop_res['author_full'], $element_loop);
			$element_loop = str_replace('%date%', $loop_res['comment_date'], $element_loop);
			$element_loop = str_replace('%type%', $loop_res['comment_type'], $element_loop);
			$element_loop = str_replace('%excerpt%', $comment_excerpt, $element_loop);


			$output .= $element_loop . "\n";


		} //foreach

		$output = convert_smilies($output);

	} else {
		$output .= $none_found;
    }

    echo $output;
}
?>
